﻿Imports System.Windows.Forms

Public Class frmMonitor
    Implements IGameForm


    Private _World As VirtualWorld
    Private _Game As Game1

    Sub New(game As Game1, world As VirtualWorld)

        ' This call is required by the designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.
        Me._Game = game
        Me._World = world
    End Sub

    Public ReadOnly Property World As VirtualWorld Implements IGameForm.World
        Get
            Return Me._World
        End Get
    End Property

    Public ReadOnly Property Game As Microsoft.Xna.Framework.Game Implements IGameForm.Game
        Get
            Return Me._Game
        End Get
    End Property

    Private Delegate Sub SetTextDelegate(m As Message, textCtl As TextBox)

    Private Sub SetText(m As Message, textCtl As TextBox)
        textCtl.AppendText(m.ToString.Replace(",", vbCrLf) & vbCrLf & vbCrLf)
    End Sub

    Public Sub OnMessageRecievedByGame(m As Message) Implements IGameForm.OnMessageRecievedByGame
        If Me.txtIncomingMessages.InvokeRequired Then
            Dim d As New SetTextDelegate(AddressOf SetText)
            Me.Invoke(d, New Object() {m, Me.txtIncomingMessages})
        Else
            Me.txtIncomingMessages.AppendText(m.ToString.Replace(",", vbCrLf) & vbCrLf & vbCrLf)
        End If
    End Sub



    Public Sub OnMessageSentByGame(m As Message) Implements IGameForm.OnMessageSentByGame
        If Me.txtOutgoingMessages.InvokeRequired Then
            Dim d As New SetTextDelegate(AddressOf SetText)
            Me.Invoke(d, New Object() {m, Me.txtOutgoingMessages})
        Else
            Me.txtOutgoingMessages.AppendText(m.ToString.Replace(",", vbCrLf) & vbCrLf & vbCrLf)
        End If
    End Sub

    Public Sub ProcessMouseCoordinates1(x As Single, y As Single) Implements IGameForm.ProcessMouseCoordinates
        Me.MouseXStatus.Text = "X = " & x
        Me.MouseYStatus.Text = "Y = " & y
    End Sub

    Private Sub btnConnect_Click(sender As System.Object, e As System.EventArgs) Handles btnConnect.Click
        Me._Game.ConnectToACTR()
    End Sub

    Private Sub btnInitialize_Click(sender As System.Object, e As System.EventArgs) Handles btnInitialize.Click
        Me._Game.FinishACTRInitialization()
    End Sub

    Private Sub btnClear_Click(sender As System.Object, e As System.EventArgs) Handles btnClear.Click
        Me.txtIncomingMessages.Clear()
        Me.txtOutgoingMessages.Clear()
    End Sub
End Class